# LDP Mybatis-Plus 脚手架介绍

本文档介绍基于Mybatis-Plus的LDP脚手架开发流程，主要包含如何进行增删改查操作，配置文件部分配置介绍，以及mybaitis集成包包含内容以及替换方式。



## 一、代码拉取

拉取最新代码:

```shell
git clone http://gitlab.dev.shxrtech.com/ldp/ldp-app-example.git -b dev_mybatis
```

拉取指定版本LDP分支：

```shell
git clone http://gitlab.dev.shxrtech.com/ldp/ldp-app-example.git -b LDP版本号_mybatis
```

**PS：mybatis版本脚手架不支持引用原脚手架base-database包（hibernate、jdbc 接口）。**

## 二、工程结构

工程一共分为4个模块：

- app-common

  应用标准功能模块（主要是一些标准功能，例如附件上传功能等）

- example-api

  样例工程api模块（主要存放entity以及一些公共api）

- example-biz

  样例工程业务模块（主要是业务代码，包含mapper、xml、service、controller）

- example-startup

  样例工程启动模块（启动类、相关配置文件）

此版本脚手架依然使用flyway来做数据库初始化sql存放目录：

- mysql：example-startup/resources/db/mysql
- oracle：example-startup/resources/db/oracle

当在本地开发、测试环境、生产环境时，有许多配置需要修改，服务分组也不一致，在example-startup模块resources目录通过分环境启动文件，在启动时传入参数，使用不同的配置文件

- bootstrap.yml

  默认配置文件，服务端口、服务名等

- bootstrap-dev.yml

  线上开发环境配置， nacos 注册 group为dev_group, weight = 1

- bootstrap-local.yml

  本地本地环境配置， nacos 注册 group为dev_group, weight = 0

- bootstrap-prod.yml

  生产环境配置， nacos 注册 group为prod_group

可以通过修改bootstrap中的spring.profiles.active使用不同配置，也可以在启动命令中传入参数指定配置：

```shell
# 使用dev配置
java –jar example-startup-1.0-SNAPSHOT.jar –-spring.profiles.active=dev
```

## 三、依赖与配置

```pom.xml

```



## 四、代码生成插件及代码生成内容

## 五、增删改查样例

